 /* 'mrABO.cpp' */

 /* Komplementarny plik nagwka */
#include "mrABO.h"

 /* Konstruktor domylny */
mrABO::mrABO (void)
{
 m_pkAnimations      = NULL;
 m_pkTexture         = NULL;
 m_iCurrentAnimation = 0;
 m_iXPosition        = 0;
 m_iYPosition        = 0;
 m_iWidth            = 0;
 m_iHeight           = 0;
 m_fAngle            = 0;
 m_fRadius           = 0;
}

 /* Destruktor domylny */
mrABO::~mrABO (void)
{
 if (NULL != m_pkAnimations)
 {
  delete [] m_pkAnimations;
  m_pkAnimations     = NULL;
 }
 if (NULL != m_pkTexture)
 {
  delete m_pkTexture;
  m_pkTexture        = NULL;
 }
 m_iCurrentAnimation = 0;
 m_iXPosition        = 0;
 m_iYPosition        = 0;
 m_iWidth            = 0;
 m_iHeight           = 0;
 m_fAngle            = 0;
 m_fRadius           = 0;
}

 /* Utwrz ABO */
void mrABO::Create (mrUInt32 iAnimations, mrAnimation * pkAnimations)
{
 m_pkAnimations = new mrAnimation [iAnimations];

 mrUInt32 iAnimation;

 for (iAnimation = 0; iAnimation < iAnimations; iAnimation ++)
 {
  SetAnimation (iAnimation, &pkAnimations [iAnimation]);
 }
}

 /* Ustaw animacj ABO */
void mrABO::SetAnimation (mrUInt32 iAnimation, mrAnimation * pkAnimation)
{
 memcpy (&m_pkAnimations [iAnimation], pkAnimation, sizeof (mrAnimation));
 m_pkAnimations [iAnimation].SetCurrentFrame (0);
}

 /* Zaaduj ABO z pliku */
void mrABO::LoadFromFile (LPSTR lpszFilename)
{
 fstream      kABO;

 kABO.open (lpszFilename, ios::in);

 if (kABO.is_open ())
 {
   /* Pobierz nazw i typ tekstury */
  mrInt8 aTextureName [256];
  kABO >> aTextureName;
  mrUInt32 iTextureType;
  kABO >> iTextureType;

   /* Zaaduj obraz z tesktur */
  mrRGBAImage kTempImage;

  if (1 == iTextureType)
  {
   kTempImage.LoadFromBitmap (aTextureName);
  }
  if (2 == iTextureType)
  {
   kTempImage.LoadFromTarga (aTextureName);
  }

   /* Odczytaj informacj o kluczowaniu kolorw */
  mrUInt32 iRed;
  mrUInt32 iGreen;
  mrUInt32 iBlue;
  kABO >> iRed;
  kABO >> iGreen;
  kABO >> iBlue;

  kTempImage.SetColorKey ((mrUInt8)iRed, (mrUInt8)iGreen, 
                          (mrUInt8)iBlue);
  
   /* Utwrz tekstur */
  m_pkTexture = new mrTexture ();
  m_pkTexture->Create (&kTempImage);

   /* Odczytaj informacje o zbiorze szablonw */
  mrUInt32 iCellWidth;
  mrUInt32 iCellHeight;
  kABO >> iCellWidth;
  kABO >> iCellHeight;

   /* Utwrz szablon */
  mrTemplateSet kTempTemplateSet;
  kTempTemplateSet.Create (m_pkTexture, kTempImage.GetWidth (), 
                           kTempImage.GetHeight (), iCellWidth, 
                           iCellHeight);

   /* Odczytaj liczb animacji */
  mrUInt32 iNumberOfAnimations;
  kABO >> iNumberOfAnimations;

  mrAnimation * pkTempAnimations;
  pkTempAnimations = new mrAnimation [iNumberOfAnimations];

  mrUInt32 iAnimation;

   /* Odczytaj liczb kadrw dla kadej animacji */
  for (iAnimation = 0; iAnimation < iNumberOfAnimations; iAnimation++)
  {
   mrUInt32 iNumberOfFrames;
   kABO >> iNumberOfFrames;

   mrCellID * pkFramePosition;
   pkFramePosition = new mrCellID [iNumberOfFrames];

   mrUInt32 iPosition;

    /* Dla kadego kadru odczytaj jego animacj */
   for (iPosition = 0; iPosition < iNumberOfFrames; iPosition++)
   {
    kABO >> pkFramePosition [iPosition].m_iX;
    kABO >> pkFramePosition [iPosition].m_iY;
   }

    /* Utwrz animacj */
   pkTempAnimations [iAnimation].Create (&kTempTemplateSet , 
                                         iNumberOfFrames, 
                                         pkFramePosition);
   delete [] pkFramePosition;
  }

   /* Utwrz ABO */
  Create (iNumberOfAnimations, pkTempAnimations);

  delete [] pkTempAnimations;

  kABO.close ();
 }
}

 /* Renderuj ABO */
mrError32 mrABO::Render (void)
{
 RECT kRect;

  /* Przelij pozycj i szeroko jako RECT */
 kRect.left   = m_iXPosition;
 kRect.top    = m_iYPosition;
 kRect.right  = m_iWidth;
 kRect.bottom = m_iHeight;

 return m_pkAnimations [m_iCurrentAnimation].Render (kRect, m_iColor, 
                                                     m_fAngle);
}

 /* Aktualizuj animacj ABO */
void mrABO::Update (void)
{
 m_pkAnimations [m_iCurrentAnimation].Update ();
}

void mrABO::SetCurrentAnimation (mrUInt32 iAnimation)
{
 m_iCurrentAnimation = iAnimation;
}

 /* Zwraca biec animacj ABO */
mrUInt32 mrABO::GetCurrentAnimation (void)
{
 return m_iCurrentAnimation;
}

 /* Sprawdza czy dwa obiekty ABO koliduj z sob */
mrBool32 mrABO::Collide (mrABO & rkABO, mrUInt32 iUseSphere)
{
  /* Zastosowanie metody okrgw opisujcych */
 if (iUseSphere)
 {
   /* Pobiera odlego od jednego ABO do drugiego */
  mrReal32 fXDelta = (mrReal32)m_iXPosition - (mrReal32)rkABO.GetXPosition ();
  mrReal32 fYDelta = (mrReal32)m_iYPosition - (mrReal32)rkABO.GetYPosition ();

  mrReal32 fDistance;
  fDistance = (mrReal32) sqrt (fXDelta * fXDelta + fYDelta * fYDelta);

  mrReal32 fRadius1, fRadius2;
 
    /* Pobierz promie kadego ABO */
  if (m_fRadius != 0)
  {
   fRadius1 = m_fRadius;
  }
  else
  {
   fRadius1 = (mrReal32) sqrt ( ((m_iWidth / 2) * (m_iWidth / 2)) + 
                                ((m_iHeight / 2) * (m_iHeight / 2)));
  }
  if (rkABO.GetRadius () != 0)
  {
   fRadius2 = rkABO.GetRadius ();
  }
  else
  {
   fRadius2 = (mrReal32) sqrt ( 
               ((rkABO.GetWidth () / 2) * (rkABO.GetWidth () / 2)) + 
               ((rkABO.GetHeight () / 2) * (rkABO.GetHeight () / 2)));
  }

   /* Jeeli odlego jest mniejsza, ni suma promieni, zwraca mrFalse */
  if (fDistance > (fRadius1 + fRadius2))
  {
   return mrFalse;
  }
  else
  {
   return mrTrue;
  }
 }
 else
 {
   /* Prostokty opisujce */
  mrInt32 iX0;
  mrInt32 iY0;
  mrInt32 iX1;
  mrInt32 iY1;

  iX0 = m_iXPosition - m_iWidth / 2;
  iY0 = m_iYPosition - m_iHeight / 2;
  iX1 = m_iXPosition + m_iWidth / 2;
  iY1 = m_iYPosition + m_iHeight / 2;

   /* Sprawd wszystkie wierzchoki, czy zawieraj punkt */
  if (rkABO.ContainsPoint (iX0, iY0))
  {
   return mrTrue;
  }
  if (rkABO.ContainsPoint (iX0, iY1))
  {
   return mrTrue;
  }
  if (rkABO.ContainsPoint (iX1, iY1))
  {
   return mrTrue;
  }
  if (rkABO.ContainsPoint (iX1, iY0))
  {
   return mrTrue;
  }
  
   /* Jeeli aden punkt nie by zawarty w rodku zwraca mrFalse */
  return mrFalse;
 }
}

 /* Sprawdza czy punkt znajduje si w obrbie prostokta */
mrBool32 mrABO::ContainsPoint (mrInt32 iX, mrInt32 iY)
{
  /* Prostokt opisujcy */
 mrInt32 iX0;
 mrInt32 iY0;
 mrInt32 iX1;
 mrInt32 iY1;

 iX0 = m_iXPosition - m_iWidth / 2;
 iY0 = m_iYPosition - m_iHeight / 2;
 iX1 = m_iXPosition + m_iWidth / 2;
 iY1 = m_iYPosition + m_iHeight / 2;

  /* Sprawdza czy punkt naley do prostokta */
 if ((iX >= iX0) && (iX <= iX1))
 {
  if ((iY >= iY0) && (iY <= iY1))
  {
   return mrTrue;
  }
 }
 return mrFalse;
}

 /* Ustawia pozycj ABO */
void mrABO::SetPosition (mrUInt32 iX, mrUInt32 iY)
{
 m_iXPosition = iX;
 m_iYPosition = iY;
}

 /* Ustawia rozmiar ABO */
void mrABO::SetSize (mrUInt32 iWidth, mrUInt32 iHeight)
{
 m_iWidth  = iWidth;
 m_iHeight = iHeight;
}

 /* Ustawia kolor ABO */
void mrABO::SetColor (mrUInt8 iAlpha, mrUInt8 iRed, mrUInt8 iGreen, 
                      mrUInt8 iBlue)
{
 m_iColor = D3DCOLOR_ARGB (iAlpha, iRed, iGreen, iBlue);
}

 /* Ustawia promie ABO */
void mrABO::SetRadius (mrReal32 fRadius)
{
 m_fRadius = fRadius;
}

 /* Obraca ABO */
void mrABO::Rotate (mrReal32 fAngle, mrUInt32 iAccumulate)
{
 if (iAccumulate)
 {
  m_fAngle += fAngle;
 }
 else
 {
  m_fAngle = fAngle;
 }
}

 /* Zwraca poziom pozycj ABO */
mrUInt32 mrABO::GetXPosition (void)
{
 return m_iXPosition;
}

 /* Zwraca pionow pozycj ABO */
mrUInt32 mrABO::GetYPosition (void)
{
 return m_iYPosition;
}

 /* Zwraca wysoko ABO */
mrUInt32 mrABO::GetHeight (void)
{
 return m_iHeight;
}

 /* Zwraca szeroko ABO */
mrUInt32 mrABO::GetWidth (void)
{
 return m_iWidth;
}

 /* Zwraca kolor ABO */
mrUInt32 mrABO::GetColor (void)
{
 return m_iColor;
}

 /* Zwraca kierunek ABO */
mrReal32 mrABO::GetDirection (void)
{
 return m_fAngle;
}

 /* Zwraca promie kolizyjny ABO */
mrReal32 mrABO::GetRadius (void)
{
 return m_fRadius;
}
